import Graphics.Gnuplot.Simple
import Control.Exception
import Text.Printf
import Data.List
import Data.Ord
{- 
    Chcemy narysować wykres funkcji na przedziale (0,1) 
    zadanej równaniem różniczkiwym: y'=-y 
    z warunkiem początkowym y(0)=1.
    I wygenerować tabelkę zależności h i błędu bezwzględnego
    (i od razu też wykres tego :)
-}
wzor :: Double -> [(Double,Double)]
wzor h = takeWhile (\(x,y)-> x<1.01) $ iterate zrob (0.0,1.0)
    where
        zrob :: (Double,Double) -> (Double,Double)
        zrob (x,_) = (x+h, exp(-(x+h)))
rownanie :: Double -> [(Double,Double)]
rownanie h = 
    takeWhile (\(x,y) -> x<1.01) $ iterate zrob (0.0,1.0) 
    where
        zrob :: (Double,Double) -> (Double,Double)
        zrob (x,y) = (x+h, y+h*(-y)) --Jawny Euler

blad :: [(Double,Double)] -> [(Double,Double)] -> [(Double,Double)]
blad l1 l2 = zipWith (\(x,y) (a,b) -> assert (abs(x-a)<=0.01) (x, abs(b-y))) l1 l2

--DO RYSOWANIA
atr x_podpis y_podpis nazwa_pliku podpis = [PNG nazwa_pliku, Title podpis ,YLabel y_podpis, XLabel x_podpis]
styl t = (defaultStyle {lineSpec = CustomStyle [LineTitle t]})

--FUNKCJE RYSUJACE
main = do
    print "Ilosc krokow    Rozmiar kroku    Max.blad"
    sequence_ $ map zrob $ map (\x -> (1/x,x)) lkroki
    where
        zrob (h,i) = do
            let lista = rownanie h
            let poprawny = wzor h
            let bl = blad poprawny lista
            plotPathsStyle (wykres_atr i h) [(styl "y(x)=e^(-x)",wzor h),(styl "y(x+h)=y(x)+h*y'(x)",lista)]
            plotPathsStyle (blad_atr i h) [(styl "|y(x)-jawny_euler(x)|" ,bl)]
            printf "%f        " i
            printf "%f        " h
            printf "%f\n" $ snd $ maximumBy (comparing snd) bl
        wykres_atr i h = [XRange(0.0,1.1)] ++ atr "x" "y" ("wykres-"++ show (floor i) ++ ".png") ("Jawna metoda Eulera dla y'=-y (y(0)=1) (h="++ printf "%f" h ++")")
        blad_atr i h = [XRange(0.0,1.1)] ++ atr "x" "blad" ("blad-"++ show (floor i) ++ ".png") ("Blad jawnej metody Eulera dla y'=-y (y(0)=1) (h="++ printf "%f" h ++")")
--        kroki = [0.5,0.25,0.2,0.1,0.05,0.025,0.02,0.01,0.005,0.0025,0.002,0.001]
        lkroki = [2,4,5,8,10,16,20,40,50,64,80,100,128,200,400,500,640,800,1000]
